from connect import create_connection
import logging

def update_customer_email(customer_id: int, email: str) -> bool:
    # Connect to the SQL Server
    conn = create_connection()
    if conn is None:
        return False

    # Update the customer email
    with conn:
        try:
            with conn.cursor() as cursor:
                cursor.execute(
                    "UPDATE Customers SET Email = %s WHERE CustomerID = %s",
                    (email, customer_id),
                )
                conn.commit()
                logging.info(f'{cursor.rowcount} rows updated successfully.')
                return True if cursor.rowcount == 1 else False
        except Exception as e:
            logging.error(f"Error updating customer email: {e}")
    
    return False  


logging.info(f'{cursor.rowcount} rows updated successfully.')
return True if cursor.rowcount == 1 else False